(() => {
    'use strict';

    // 戦闘中にテキストを表示するためのスプライトクラス
    function Sprite_PopupText() {
        this.initialize(...arguments);
    }

    Sprite_PopupText.prototype = Object.create(Sprite.prototype);
    Sprite_PopupText.prototype.constructor = Sprite_PopupText;

    // 初期処理
    Sprite_PopupText.prototype.initialize = function(spriteset) {
        Sprite.prototype.initialize.call(this);
        this._target = null;
        this._duration = 0;
        this.bitmap = new Bitmap(200, 32);

        // 文字情報の設定（ダメージ表示に合わせる）
        this.bitmap.fontFace = Sprite_Damage.prototype.fontFace();
        this.bitmap.fontSize = Sprite_Damage.prototype.fontSize();
        this.bitmap.fontBold = true;

        // 縁設定
        this.bitmap.outlineColor = Sprite_Damage.prototype.outlineColor();
        this.outlineWidth = Sprite_Damage.prototype.outlineWidth();


        this.anchor.x = 0.5;
        this.anchor.y = 1;
        this._spriteset = spriteset;
        this.updatePosition();
    };

    // 文字表示等の準備処理
    Sprite_PopupText.prototype.setup = function(target, text) {
        this._target = target;
        this._duration = 60; // 表示フレーム数（1秒）
        this.opacity = 255;
        this.bitmap.drawText(text, 0, 0, this.bitmap.width, this.bitmap.height, "center");
        this.updatePosition();
    };

    // 更新処理
    Sprite_PopupText.prototype.update = function() {
        Sprite.prototype.update.call(this);

        this._duration--;
        this.updatePosition();
        this.updateFade();

        if (this._duration <= 0) {
            this._spriteset.returnPopupTextSprite(this);
        }
    };
    
    // フェード処理
    Sprite_PopupText.prototype.updateFade = function() {
        if (this._duration < 20) {
            this.opacity = (this._duration / 20) * 255;
        }
    };

    // 表示位置
    Sprite_PopupText.prototype.updatePosition = function() {
        if (!this._target) return;
        
        // 対象スプライトを取得して、表示位置を算出
        const sprite = this._spriteset.findTargetSprite(this._target);
        if (sprite) {
            // 対象が敵の場合は中心に表示
            if (this._target.isEnemy()) {
                this.anchor.set(0.5, 0.5);
                this.y = sprite.y;
            // 対象が味方の場合は頭の上に出すように調整
            } else {
                this.anchor.set(0.5, 1.0);
                this.x = sprite.x;
                this.y = sprite.y - 80;
            }
            
        }
    };

    // バトル用スプライトセットの初期化処理
    const _Spriteset_Battle_initialize = Spriteset_Battle.prototype.initialize;
    Spriteset_Battle.prototype.initialize = function() {
        _Spriteset_Battle_initialize.call(this);
       
        // ポップアップテキストのプール用の配列
        this._popupTextPool = [];
    };

    // 戦闘用スプライトセットのレイヤー作成処理に追加
    const _Spriteset_Battle_createLowerLayer = Spriteset_Battle.prototype.createLowerLayer;
    Spriteset_Battle.prototype.createLowerLayer = function() {
        _Spriteset_Battle_createLowerLayer.call(this);
        this.createPopupTextLayer();
    };

    // バトル用のスプライトセットに専用レイヤーを用意
    Spriteset_Battle.prototype.createPopupTextLayer = function() {
        this._popupTextLayer = new Sprite();
        this.addChild(this._popupTextLayer);
    };

    // 文字表示用の関数
    Spriteset_Battle.prototype.showPopupText = function(target, text) {
        const sprite = this.getPopupTextSprite();
        sprite.setup(target, text);
        sprite.visible = true;
        this._popupTextLayer.addChild(sprite);
    };

    // ポップアップテキストのスプライト取得処理
    Spriteset_Battle.prototype.getPopupTextSprite = function() {
        // 作成済みのものがあればそれを使用、なければ作成
        return this._popupTextPool.pop() || new Sprite_PopupText(this);
    };

    // 使い終わったポップアップテキストをプールに返却する
    Spriteset_Battle.prototype.returnPopupTextSprite = function(sprite) {
        sprite.visible = false;
        this._popupTextPool.push(sprite);
    };

    // 戦闘中に呼び出すための関数
    BattleManager.showPopupText = function(target, text) {
        const scene = SceneManager._scene;
        if (scene && scene._spriteset) {
            scene._spriteset.showPopupText(target, text);
        }
    };
   
})();